package ru.yandex.crypta.common.ws;

import io.swagger.models.Swagger;
import org.glassfish.jersey.internal.inject.AbstractBinder;

import ru.yandex.crypta.common.ws.jersey.ReflectionJerseyResourceConfig;
import ru.yandex.crypta.common.ws.jersey.Throttle;
import ru.yandex.crypta.common.ws.jetty.JettyServer;
import ru.yandex.crypta.common.ws.swagger.SwaggerUtils;

public abstract class DefaultWsApplication {

    protected abstract Class<?> getRestRootClass();

    protected abstract Swagger getSwagger();

    protected String getPrefix() {
        return "api";
    }

    protected AbstractBinder getBinder() {
        return new AbstractBinder() {
            @Override
            protected void configure() {
                bindCustom(this);
                bindSwagger(this);
                bindDefaults();
            }

            private void bindDefaults() {
                bind(Throttle.class).to(Throttle.class);
            }
        };
    }

    public ReflectionJerseyResourceConfig getResourceConfig() {
        return new ReflectionJerseyResourceConfig(getRestRootClass(), getBinder());
    }

    public AbstractServer createServer() {
        return new JettyServer(getResourceConfig(), getPrefix(), getPort());
    }

    protected abstract int getPort();

    protected Swagger createSwagger() {
        return SwaggerUtils.createFromPackage(getRestRootClass().getPackage(), getPrefix());
    }

    protected abstract void bindCustom(AbstractBinder binder);

    protected void bindSwagger(AbstractBinder binder) {
        binder.bind(getSwagger()).to(Swagger.class);
    }


}
