package ru.yandex.crypta.common.ws;

import java.util.List;
import java.util.stream.Collectors;

import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class Security {

    private static final String AUTHORIZATION = "authorization";
    private static final String COOKIE = "cookie";
    private static final String X_YA_SERVICE_TICKET = "x-ya-service-ticket";

    private Security() {

    }

    private static void screenHeaders(MultivaluedMap<String, String> screenedHeaders, String headerName) {
        List<String> newHeaders = screenedHeaders.get(headerName);
        if (newHeaders != null) {
            List<String> screenedAuthorization = newHeaders
                    .stream()
                    .map(i -> "***")
                    .collect(Collectors.toList());
            screenedHeaders.put(headerName, screenedAuthorization);
        }
    }

    public static MultivaluedMap<String, String> screened(MultivaluedMap<String, String> headers) {
        MultivaluedMap<String, String> screenedHeaders = new MultivaluedHashMap<>();
        headers.forEach((key, value) -> {
            String safeKey = key.toLowerCase();
            screenedHeaders.put(safeKey, value);
        });

        screenHeaders(screenedHeaders, AUTHORIZATION);
        screenHeaders(screenedHeaders, COOKIE);
        screenHeaders(screenedHeaders, X_YA_SERVICE_TICKET);

        return screenedHeaders;
    }


}
