package ru.yandex.crypta.common.ws.auth;

public class Authenticator {

    private final String login;
    private final String puid;
    private final AuthMethod method;

    public Authenticator(String login, String puid, AuthMethod method) {
        this.login = login;
        this.puid = puid;
        this.method = method;
    }

    public String getLogin() {
        return login;
    }

    public String getPuid() {
        return puid;
    }

    public AuthMethod getMethod() {
        return method;
    }

    public static Authenticator develop(String login) {
        return new Authenticator(login.isEmpty() ? System.getProperty("user.name") : login, "0", AuthMethod.UNKNOWN);
    }

}
