package ru.yandex.crypta.common.ws.auth;

import java.security.Principal;
import java.util.Objects;

import javax.ws.rs.core.SecurityContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.clients.idm.RoleService;
import ru.yandex.crypta.idm.Roles;
import ru.yandex.crypta.lib.proto.TDevelopmentFlags;

public class IdmSecurityContext implements SecurityContext {

    private static final Logger LOG = LoggerFactory.getLogger(IdmSecurityContext.class);
    private final boolean rolesDisabled;
    private final RoleService roleService;
    private final LoginPrincipal principal;
    private final Authenticator authenticator;

    public IdmSecurityContext(TDevelopmentFlags flags, RoleService roleService, Authenticator authenticator) {
        this.rolesDisabled = flags.getDisableIdm();
        this.roleService = roleService;
        this.principal = new LoginPrincipal(authenticator.getLogin().replaceAll("^\"|\"$", ""));
        this.authenticator = authenticator;
    }

    @Override
    public Principal getUserPrincipal() {
        return principal;
    }

    @Override
    public boolean isUserInRole(String role) {
        if (rolesDisabled) {
            return true;
        }

        if (authenticator.getMethod().equals(AuthMethod.TVM)) {
            if (role.equals(authenticator.getLogin())) {
                return true;
            }
        }

        String principalName = getUserPrincipal().getName();
        boolean isUserInRole = roleService.getRoles(principalName)
                .stream()
                .anyMatch(each -> Objects.equals(Roles.INSTANCE.toId(each), role));

        if (!isUserInRole) {
            LOG.info("User {} has no role {}", principalName, role);
        }

        return isUserInRole;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public String getAuthenticationScheme() {
        return "IDM";
    }

}
