package ru.yandex.crypta.common.ws.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.inject.Singleton;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.glassfish.jersey.internal.inject.AbstractBinder;

import ru.yandex.crypta.common.exception.Exceptions;

public class ConfigUtils {

    public static void bindFields(Message message, AbstractBinder binder) {
        message.getDescriptorForType()
                .getFields()
                .forEach(each -> {
                    Method method = getGetter(message.getClass(), each);
                    Class<?> returnType = method.getReturnType();
                    if (returnType.isPrimitive()) {
                        // skip any primitives so we don't bind integers
                        return;
                    }
                    Object value = callGetter(message, each, method);
                    binder.bind(value)
                            .to(returnType)
                            .in(Singleton.class);
                    if (value instanceof Message) {
                        bindFields((Message) value, binder);
                    }
                });
    }

    private static Object callGetter(Message message, Descriptors.FieldDescriptor each, Method method) {
        try {
            return method.invoke(message);
        } catch (IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.internal("Failed to obtain " + each.getName());
        }
    }

    private static Method getGetter(Class<? extends Message> clazz, Descriptors.FieldDescriptor each) {
        try {
            return clazz.getMethod("get" + each.getName());
        } catch (NoSuchMethodException e) {
            throw Exceptions.internal("Failed to get the getter for " + each.getName());
        }
    }

}
