package ru.yandex.crypta.common.ws.jersey;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

import javax.inject.Inject;
import javax.inject.Provider;

public class IpAware {

    private static final String UNKNOWN_ADDRESS = "0.0.0.0";

    @Inject
    private Provider<org.eclipse.jetty.server.Request> jettyRequest;

    protected String getRemoteAddr() {
        if (Objects.nonNull(jettyRequest.get())) {
            return jettyRequest.get().getRemoteAddr();
        } else {
            return UNKNOWN_ADDRESS;
        }
    }

    protected InetAddress getTypedRemoteAddr() {
        try {
            return InetAddress.getByName(getRemoteAddr());
        } catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress();
        }
    }

}
