package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import ru.yandex.crypta.common.exception.BadAuthenticationException;

public class BadAuthenticationExceptionMapper
        extends BaseExceptionMapper implements ExceptionMapper<BadAuthenticationException>
{
    @Override
    public Response toResponse(BadAuthenticationException exception) {
        NeedAuthenticationMessage message = new NeedAuthenticationMessage("Not authenticated", getRequestId())
                .withAuthenticationUrl(exception.getAuthenticationUrl());
        return jsonResponse(401, message).build();
    }
}
