package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.inject.Provider;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import ru.yandex.crypta.common.ws.jersey.ContextIdentifiers;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;

public class BaseExceptionMapper {

    @Context
    private Provider<ContainerRequestContext> requestContextProvider;

    private ContainerRequestContext getRequestContext() {
        return requestContextProvider.get();
    }

    protected String getRequestId() {
        return ContextIdentifiers.getRequestId(getRequestContext());
    }

    protected Response.ResponseBuilder jsonResponse(int status, Object entity) {
        return Response
                .status(status)
                .entity(entity)
                .type(JsonUtf8.MEDIA_TYPE);
    }

}
