package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import com.google.common.collect.ImmutableMap;
import org.hibernate.validator.internal.engine.path.PathImpl;

public class ConstraintViolationExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<ConstraintViolationException> {

    @Override
    public Response toResponse(ConstraintViolationException exception) {
        Set<ConstraintViolation<?>> constraintViolations = exception.getConstraintViolations();
        List<SimpleConstraintViolation> simpleConstraintViolations = constraintViolations.stream()
                .map(each -> {
                    String name = ((PathImpl) each.getPropertyPath()).getLeafNode().getName();
                    String message = each.getMessage();
                    Object invalidValue = each.getInvalidValue();
                    return new SimpleConstraintViolation(name, invalidValue, message);
                })
                .collect(Collectors.toList());
        Map message = ImmutableMap.of(
                "message", "Parameter validation failed",
                "violations", simpleConstraintViolations,
                "requestId", getRequestId()
        );
        return jsonResponse(400, message).build();
    }

    public static class SimpleConstraintViolation {

        private final Object invalidValue;
        private final String message;
        private final String name;

        public SimpleConstraintViolation(String name, Object value, String message) {
            this.name = name;
            this.invalidValue = value;
            this.message = message;
        }

        public String getName() {
            return name;
        }

        public Object getInvalidValue() {
            return invalidValue;
        }

        public String getMessage() {
            return message;
        }
    }
}
