package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import java.util.Objects;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import org.jooq.exception.DataAccessException;
import org.jooq.exception.SQLStateClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAccessExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<DataAccessException> {

    private static final Logger LOG = LoggerFactory.getLogger(DataAccessExceptionMapper.class);

    @Override
    public Response toResponse(DataAccessException exception) {
        LOG.error(exception.getMessage(), exception);
        SQLStateClass sqlStateClass = exception.sqlStateClass();
        if (Objects.equals(SQLStateClass.C08_CONNECTION_EXCEPTION, sqlStateClass)) {
            var message = new ErrorMessage("Database temporary unavailable", getRequestId());
            return jsonResponse(503, message).build();
        } else {
            var message = new ErrorMessage("Database error: " + exception.sqlStateClass(), getRequestId());
            return jsonResponse(400, message).build();
        }
    }
}
