package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;

public class ErrorMessage {

    private final String message;
    private final String requestId;
    private String code;

    public ErrorMessage(String message, String requestId) {
        this.message = message;
        this.requestId = requestId;
    }

    public String getRequestId() {
        return requestId;
    }

    public String getMessage() {
        return message;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCode() {
        return code;
    }

    public ErrorMessage withCode(String code) {
        this.code = code;
        return this;
    }
}
