package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import ru.yandex.crypta.common.exception.ForbiddenException;

public class ForbiddenExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<ForbiddenException> {
    @Override
    public Response toResponse(ForbiddenException exception) {
        var message = new ErrorMessage(exception.getMessage(), getRequestId()).withCode(exception.getCode());
        return jsonResponse(403, message).build();
    }
}
