package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import java.util.Objects;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastResortExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<Throwable> {

    private static final Logger LOG = LoggerFactory.getLogger(LastResortExceptionMapper.class);

    @Override
    public Response toResponse(Throwable exception) {
        if (Objects.isNull(exception)) {
            LOG.error("Null is thrown");
            return jsonResponse(500, new ErrorMessage("Internal server error", getRequestId()))
                    .build();
        }
        LOG.error(exception.getMessage(), exception);

        if (exception.getCause() instanceof MessageBodyProviderNotFoundException) {
            return jsonResponse(400, new ErrorMessage("Unsupported response type", getRequestId()))
                    .build();
        }
        return jsonResponse(500, new ErrorMessage("Server error", getRequestId())).build();
    }
}
