package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import com.fasterxml.jackson.annotation.JsonInclude;

public class NeedAuthenticationMessage extends ErrorMessage {
    private String authenticationUrl;

    public NeedAuthenticationMessage(String message, String requestId) {
        super(message, requestId);
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getAuthenticationUrl() {
        return authenticationUrl;
    }

    public NeedAuthenticationMessage withAuthenticationUrl(String authenticationUrl) {
        this.authenticationUrl = authenticationUrl;
        return this;
    }
}
