package ru.yandex.crypta.common.ws.jersey.exception.mapper;


import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import ru.yandex.crypta.common.exception.NotAuthenticatedException;

public class NotAuthenticatedExceptionMapper
        extends BaseExceptionMapper implements ExceptionMapper<NotAuthenticatedException>
{
    @Override
    public Response toResponse(NotAuthenticatedException exception) {
        var message = new ErrorMessage(exception.getMessage(), getRequestId());
        return jsonResponse(403, message).build();
    }
}
