package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import ru.yandex.crypta.common.exception.OutdatedAuthenticationException;

public class OutdatedAuthenticationExceptionMapper
        extends BaseExceptionMapper implements ExceptionMapper<OutdatedAuthenticationException>
{
    @Override
    public Response toResponse(OutdatedAuthenticationException exception) {
        var message = new NeedAuthenticationMessage("Authentication needs to be updated", getRequestId())
                .withAuthenticationUrl(exception.getAuthenticationUrl());
        return jsonResponse(419, message).build();
    }
}
