package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import org.glassfish.jersey.server.ParamException;

public class ParamExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<ParamException> {
    @Override
    public Response toResponse(ParamException exception) {
        var message = new ErrorMessage("Wrong parameter: " + exception.getParameterName(), getRequestId());
        return jsonResponse(400, message).build();
    }
}
