package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.common.exception.UnavailableException;

public class UnavailableExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<UnavailableException> {

    private static final Logger LOG = LoggerFactory.getLogger(UnavailableException.class);

    @Override
    public Response toResponse(UnavailableException exception) {
        LOG.error(exception.getMessage(), exception);
        var message =
                new ErrorMessage("Temporary unavailable", getRequestId()).withCode("TEMPORARY_UNAVAILABLE");
        return jsonResponse(503, message).build();
    }

}
