package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

public class UnsupportedOperationExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<UnsupportedOperationException> {
    @Override
    public Response toResponse(UnsupportedOperationException exception) {
        var message = new ErrorMessage("Operation is not supported", getRequestId())
                .withCode("UNSUPPORTED_OPERATION");
        return jsonResponse(400, message).build();
    }
}
