package ru.yandex.crypta.common.ws.jersey.exception.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

import ru.yandex.crypta.common.exception.WrongRequestException;

public class WrongRequestExceptionMapper extends BaseExceptionMapper implements ExceptionMapper<WrongRequestException> {
    @Override
    public Response toResponse(WrongRequestException exception) {
        var message = new ErrorMessage(exception.getMessage(), getRequestId()).withCode(exception.getCode());
        return jsonResponse(400, message).build();
    }
}
