package ru.yandex.crypta.common.ws.jersey.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;

import ru.yandex.crypta.lib.proto.TDevelopmentFlags;

public class CorsResponseFilter implements ContainerResponseFilter {

    private static final Pattern VALID_ORIGINS =
            Pattern.compile("^https://[A-Za-z0-9-.]{1,63}[.](yandex-team[.]ru|yandex[.]net|yandex[.]ru)(:[0-9]+)?$");

    private final boolean authDisabled;

    @Inject
    public CorsResponseFilter(TDevelopmentFlags flags) {
        this.authDisabled = flags.getDisableAuth();
    }

    private static List<Object> asList(String string) {
        return Collections.singletonList(string);
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext)
            throws IOException
    {
        MultivaluedMap<String, Object> headers = responseContext.getHeaders();

        String origin = requestContext.getHeaderString("origin");
        if (isValidOrigin(origin)) {
            headers.put("Access-Control-Allow-Methods", asList("GET,PUT,POST,DELETE,OPTIONS"));
            headers.put("Access-Control-Allow-Headers",
                    asList("Content-Type,Authorization,X-Requested-With,Content-Length,Accept,Origin,"));
            headers.put("Access-Control-Allow-Origin", asList(origin));
            headers.put("Access-Control-Allow-Credentials", asList("true"));
        }
    }

    private boolean isValidOrigin(String origin) {
        if (Objects.isNull(origin)) {
            return false;
        }
        if (Objects.equals("null", origin)) {
            return false;
        }
        if (authDisabled) {
            return true;
        }
        return VALID_ORIGINS.matcher(origin).matches();
    }

}
