package ru.yandex.crypta.common.ws.jersey.filter;

import java.io.IOException;
import java.net.URI;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

import ru.yandex.crypta.common.ws.Security;
import ru.yandex.crypta.common.ws.jersey.ContextIdentifiers;
import ru.yandex.crypta.common.ws.jersey.IpAware;
import ru.yandex.crypta.common.ws.solomon.Solomon;
import ru.yandex.monlib.metrics.primitives.Rate;

@PreMatching
public class LoggingRequestFilter extends IpAware implements ContainerRequestFilter {

    private static final Logger LOG = LoggerFactory.getLogger(LoggingRequestFilter.class);
    private static final Rate REQUEST_RATE = Solomon.REGISTRY.rate("request.total");

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        MDC.clear();
        MultivaluedMap<String, String> headers = requestContext.getHeaders();
        ContextIdentifiers.prepareRequest(requestContext, headers);
        URI requestUrl = requestContext.getUriInfo().getRequestUri();
        String remoteAddr = getRemoteAddr();
        String method = requestContext.getMethod();
        MDC.put("request_url", requestUrl.toASCIIString());
        MDC.put("request_from", remoteAddr);
        MDC.put("request_headers", Security.screened(headers).toString());
        MDC.put("request_method", method);
        LOG.info("Request {} {}", method, requestUrl);
        REQUEST_RATE.inc();
    }

}
