package ru.yandex.crypta.common.ws.jersey.filter;

import java.net.URI;
import java.util.Objects;

import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.MultivaluedMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

import ru.yandex.crypta.common.ws.jersey.ContextIdentifiers;

public class LoggingResponseFilter implements ContainerResponseFilter {

    private static final Logger LOG = LoggerFactory.getLogger(LoggingRequestFilter.class);

    @Inject
    private ResourceInfo resourceInfo;

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext)
    {
        ContextIdentifiers.finalizeResponse(requestContext, responseContext, resourceInfo);
        String method = requestContext.getMethod();
        int status = responseContext.getStatus();
        URI requestUri = requestContext.getUriInfo().getRequestUri();
        MultivaluedMap<String, Object> headers = responseContext.getHeaders();
        MDC.put("response_status", String.valueOf(status));
        MDC.put("response_headers", headers.toString());
        if (Objects.nonNull(resourceInfo)) {
            if (Objects.nonNull(resourceInfo.getResourceClass())) {
                MDC.put("jax_rs_class", resourceInfo.getResourceClass().getName());
            }
            if (Objects.nonNull(resourceInfo.getResourceMethod())) {
                MDC.put("jax_rs_method", resourceInfo.getResourceMethod().getName());
            }
        }

        LOG.info("Response {} {} {}", status, method, requestUri);
        MDC.clear();
    }
}
