package ru.yandex.crypta.common.ws.jersey.filter;

import java.io.IOException;

import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;

import ru.yandex.crypta.common.exception.TooManyRequestsException;
import ru.yandex.crypta.common.ws.jersey.Throttle;
import ru.yandex.crypta.common.ws.solomon.Solomon;
import ru.yandex.monlib.metrics.primitives.Rate;

@PreMatching
public class ThrottlingRequestFilter implements ContainerRequestFilter {

    private static final Rate THROTTLED_RATE = Solomon.REGISTRY.rate("request.throttled");
    private Throttle throttle;

    @Inject
    public ThrottlingRequestFilter(Throttle throttle) {
        this.throttle = throttle;
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!throttle.isOpen()) {
            THROTTLED_RATE.inc();
            throw new TooManyRequestsException();
        }
    }
}
