package ru.yandex.crypta.common.ws.jersey.resolver;

import javax.inject.Inject;
import javax.ws.rs.ext.ContextResolver;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.crypta.common.ws.json.PrettyJsonWithProtobufSupport;
import ru.yandex.crypta.lib.proto.TWsIoConfig;

public class CustomJacksonObjectMapperContextResolver implements ContextResolver<ObjectMapper> {

    private TWsIoConfig config;

    @Inject
    public CustomJacksonObjectMapperContextResolver(TWsIoConfig config) {
        this.config = config;
    }

    @Override
    public ObjectMapper getContext(Class<?> type) {
        return PrettyJsonWithProtobufSupport.create(config);
    }
}

