package ru.yandex.crypta.common.ws.jersey.resource;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;

import ru.yandex.crypta.clients.tvm.IDefaultTvmClient;
import ru.yandex.crypta.common.exception.Exceptions;
import ru.yandex.crypta.common.ws.auth.AuthNotRequired;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.passport.tvmauth.ClientStatus;

@Path("ping")
@Api(tags = {"checks"})
@Produces(JsonUtf8.MEDIA_TYPE)
public class HealthResource {
    private final IDefaultTvmClient tvm;

    @Inject
    public HealthResource(IDefaultTvmClient tvm) {
        this.tvm = tvm;
    }

    @GET
    @AuthNotRequired
    public Response ping() {
        var status = tvm.getStatus();

        if (status.getCode() != ClientStatus.Code.OK && status.getCode() != ClientStatus.Code.WARNING) {
            throw Exceptions.internal("Bad TVM status");
        }

        return Response
                .ok()
                .type(JsonUtf8.MEDIA_TYPE)
                .entity(ImmutableMap
                        .builder()
                        .put("status", "OK")
                        .build())
                .build();
    }
}
