package ru.yandex.crypta.common.ws.jersey.resource;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.common.ws.auth.AuthNotRequired;
import ru.yandex.crypta.common.ws.jersey.JsonUtf8;
import ru.yandex.crypta.common.ws.solomon.JvmThreads;
import ru.yandex.crypta.common.ws.solomon.Solomon;
import ru.yandex.crypta.lib.schedulers.Schedulers;
import ru.yandex.monlib.metrics.CompositeMetricSupplier;
import ru.yandex.monlib.metrics.encode.json.MetricJsonEncoder;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@Path("solomon")
@Api(tags = {"checks"})
@Produces(JsonUtf8.MEDIA_TYPE)
public class SolomonResource {
    private final static Logger LOG = LoggerFactory.getLogger(SolomonResource.class);

    public final MetricRegistry threadPoolRegistry;

    @Inject
    @SuppressWarnings("FutureReturnValueIgnored")
    public SolomonResource(Schedulers schedulers) {
        threadPoolRegistry = new MetricRegistry();

        schedulers.getExecutor().scheduleAtFixedRate(() -> {
                    JvmThreads.addThreadGroupMetrics(
                            threadPoolRegistry,
                            "threadPool",
                            JvmThreads::extractPoolNameByLastNumber
                    );
                    if (threadPoolRegistry.estimateCount() > 10000) {
                        LOG.warn("Too many pool metrics");
                    }
                },
                0, 1, TimeUnit.MINUTES
        );
    }

    @GET
    @AuthNotRequired
    public Response getSensors() {

        CompositeMetricSupplier metricsSupplier = new CompositeMetricSupplier(List.of(
                Solomon.REGISTRY,
                threadPoolRegistry
        ));

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (MetricJsonEncoder encoder = new MetricJsonEncoder(stream)) {
            metricsSupplier.supply(0, encoder);
        }
        return Response.ok(stream.toString(StandardCharsets.UTF_8)).build();
    }

}
