package ru.yandex.crypta.common.ws.jersey.validation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.validation.ParameterNameProvider;
import javax.ws.rs.FormParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.ext.ContextResolver;

import org.glassfish.jersey.server.validation.ValidationConfig;

public class CustomValidationConfigContextResolver implements ContextResolver<ValidationConfig> {

    @Override
    public ValidationConfig getContext(Class<?> type) {
        final ValidationConfig config = new ValidationConfig();
        config.parameterNameProvider(new ResolvingParameterNameProvider());
        return config;
    }

    public static class ResolvingParameterNameProvider implements ParameterNameProvider {

        @Override
        public List<String> getParameterNames(Constructor<?> constructor) {
            return Stream.of(constructor.getParameters()).map(Parameter::getName).collect(Collectors.toList());
        }

        @Override
        public List<String> getParameterNames(Method method) {
            return Stream.of(method.getParameters()).map(this::extractParameterName).collect(Collectors.toList());
        }

        private String extractParameterName(Parameter each) {
            PathParam pathParam = each.getAnnotation(PathParam.class);
            if (pathParam != null) {
                return pathParam.value();
            }
            QueryParam queryParam = each.getAnnotation(QueryParam.class);
            if (queryParam != null) {
                return queryParam.value();
            }
            FormParam formParam = each.getAnnotation(FormParam.class);
            if (formParam != null) {
                return formParam.value();
            }

            return each.getName();
        }
    }
}
