package ru.yandex.crypta.common.ws.jetty;

import java.net.URI;
import java.util.stream.Stream;

import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.glassfish.jersey.jetty.JettyHttpContainerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.crypta.common.ws.AbstractServer;
import ru.yandex.crypta.common.ws.jersey.ReflectionJerseyResourceConfig;

public class JettyServer extends AbstractServer {

    private static final Logger LOG = LoggerFactory.getLogger(JettyServer.class);

    private final Server server;

    public JettyServer(ReflectionJerseyResourceConfig resourceConfig, String prefix, int port) {
        super(resourceConfig, port);
        server = createHttpServer(prefix);

        // disable Server header
        Stream.of(server.getConnectors())
                .flatMap(connector -> connector.getConnectionFactories().stream())
                .filter(HttpConfiguration.ConnectionFactory.class::isInstance)
                .map(HttpConfiguration.ConnectionFactory.class::cast)
                .map(HttpConfiguration.ConnectionFactory::getHttpConfiguration)
                .forEach(factory -> factory.setSendServerVersion(false));
    }

    @Override
    @SuppressWarnings("EmptyCatch")
    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                server.stop();
            } catch (Exception ignored) {
            }
        }));
        try {
            server.start();
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            try {
                server.destroy();
            } catch (Exception e) {
            }
        }
    }

    private Server createHttpServer(String prefix) {
        URI uri = getUri().path(prefix).build();
        LOG.info("Starting Jetty server at {}", uri);
        return JettyHttpContainerFactory.createServer(uri, getResourceConfig(), DO_NOT_START);
    }
}
