package ru.yandex.crypta.common.ws.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import ru.yandex.crypta.common.ws.json.protobuf.ProtobufModule;
import ru.yandex.crypta.lib.proto.TWsIoConfig;

public class PrettyJsonWithProtobufSupport {

    private PrettyJsonWithProtobufSupport() {
    }

    public static ObjectMapper create(TWsIoConfig config) {
        ObjectMapper objectMapper = new ObjectMapper();
        enablePrettyPrinting(objectMapper);
        registerProtobufModule(objectMapper, config);

        return objectMapper;
    }

    private static ObjectMapper registerProtobufModule(ObjectMapper objectMapper,
            TWsIoConfig config)
    {
        return objectMapper.registerModule(new ProtobufModule(config));
    }

    private static ObjectMapper enablePrettyPrinting(ObjectMapper objectMapper) {
        return objectMapper
                .configure(SerializationFeature.INDENT_OUTPUT, true)
                .configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)
                .enable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)
                .setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}
