package ru.yandex.crypta.common.ws.json.protobuf;

import com.google.common.base.CaseFormat;

public class Naming {

    private Naming() {

    }

    public static String normalize(String fieldName) {
        if (Character.isUpperCase(fieldName.charAt(0))) {
            return fieldName;
        } else {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName);
        }
    }

    private static boolean isAllUpperCaseUnderscore(String propertyName) {
        return propertyName.codePoints().noneMatch(Character::isLowerCase) && propertyName.indexOf('_') != -1;
    }

    public static String normalizeForGetter(String propertyName) {
        if (isAllUpperCaseUnderscore(propertyName)) {
            return propertyName.replaceAll("_", "");
        } else if (Character.isUpperCase(propertyName.charAt(0))) {
            return propertyName;
        } else {
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, propertyName);
        }
    }
}
