package ru.yandex.crypta.common.ws.json.protobuf;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.google.protobuf.MessageOrBuilder;

import ru.yandex.crypta.lib.proto.TWsIoConfig;

public class ProtobufModule extends Module {

    private static final Version VERSION = new Version(1, 0, 0, null, "crypta", "protobuf");

    private final TWsIoConfig config;

    public ProtobufModule(TWsIoConfig config) {
        this.config = config;
    }

    @Override
    public String getModuleName() {
        return "ProtobufModule";
    }

    @Override
    public Version version() {
        return VERSION;
    }

    @Override
    public void setupModule(SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(new ProtobufSerializer(config));

        context.addSerializers(serializers);
        context.addDeserializers(new ProtobufDeserializerFactory(config));
        context.setMixInAnnotations(MessageOrBuilder.class, MessageOrBuilderMixin.class);
    }

    @JsonAutoDetect(getterVisibility = JsonAutoDetect.Visibility.NONE,
            isGetterVisibility = JsonAutoDetect.Visibility.NONE,
            setterVisibility = JsonAutoDetect.Visibility.NONE,
            creatorVisibility = JsonAutoDetect.Visibility.NONE,
            fieldVisibility = JsonAutoDetect.Visibility.NONE)
    private static class MessageOrBuilderMixin {
    }
}
