package ru.yandex.crypta.common.ws.logging;

import com.fasterxml.jackson.core.JsonGenerator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;

public class QloudAwareJsonGeneratorDecorator implements JsonGeneratorDecorator {
    @Override
    public JsonGenerator decorate(JsonGenerator generator) {
        if ("true".equals(System.getenv().get("QLOUD_LOGGER_STDOUT"))) {
            return generator;
        } else {
            return generator.useDefaultPrettyPrinter();
        }
    }
}
