package ru.yandex.crypta.common.ws.swagger;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

import io.swagger.annotations.Api;
import io.swagger.models.Swagger;

@Path("/")
@Api(hidden = true)
@Produces("application/json;charset=utf-8")
public class SwaggerResource {

    private Swagger swagger;

    @Inject
    public SwaggerResource(Swagger swagger) {
        this.swagger = swagger;
    }

    @Path("swagger.json")
    @GET
    public Swagger getDefinition() {
        return swagger;
    }

}
