package ru.yandex.crypta.common.ws.swagger.proto;

import java.lang.reflect.InvocationTargetException;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MessageOrBuilder;

import ru.yandex.crypta.common.ws.json.protobuf.Naming;


public class ProtobufPOJOPropertiesCollector extends POJOPropertiesCollector {

    protected static final String LIST_SUFFIX = "List";
    protected static final String GET = "get";
    protected static final Class[] NO_ARGS = {};

    public ProtobufPOJOPropertiesCollector(MapperConfig<?> config, boolean forSerialization, JavaType type,
            AnnotatedClass classDef, String mutatorPrefix)
    {
        super(config, forSerialization, type, classDef, mutatorPrefix);
    }

    @Override
    protected void collectAll() {
        super.collectAll();
        maybeCollectProtobufProperties();
    }

    private void maybeCollectProtobufProperties() {
        if (isProtobufMessage()) {
            Class<? extends MessageOrBuilder> messageClass = asProtobufMessage();
            getMessageDescriptor(messageClass).getFields().forEach((field) -> {
                PropertyName propertyName = getPropertyName(field);
                POJOPropertyBuilder propertyBuilder = getPojoPropertyBuilder(propertyName);
                AnnotatedMethod getter = findGetter(field, propertyName);
                registerGetter(propertyName, propertyBuilder, getter);
            });
        }
    }

    private PropertyName getPropertyName(Descriptors.FieldDescriptor field) {
        return PropertyName.construct(Naming.normalize(field.getName()));
    }

    private boolean isProtobufMessage() {
        return MessageOrBuilder.class.isAssignableFrom(_type.getRawClass());
    }

    private Class<? extends MessageOrBuilder> asProtobufMessage() {
        return _type.getRawClass().asSubclass(MessageOrBuilder.class);
    }

    private void registerGetter(PropertyName propertyName, POJOPropertyBuilder propertyBuilder,
            AnnotatedMethod getter)
    {
        if (getter != null) {
            final boolean explName = false;
            final boolean visible = true;
            final boolean ignored = false;
            propertyBuilder.addGetter(getter, propertyName, explName, visible, ignored);
        } else {
            throw new ProtobufIntrospectionFailedException("Getter not found for " + propertyName.getSimpleName());
        }
    }

    private AnnotatedMethod findGetter(Descriptors.FieldDescriptor field, PropertyName propertyName) {
        String getterName = obtainGetterName(field, propertyName);
        return _classDef.findMethod(getterName, NO_ARGS);
    }

    private String obtainGetterName(Descriptors.FieldDescriptor field, PropertyName propertyName) {
        String getterName = GET + Naming.normalizeForGetter(propertyName.getSimpleName());

        // https://st.yandex-team.ru/CRYPTA-16863
        if (getterName.equals("getDspEndpoints500msJsonOptionId")) {
            getterName = "getDspEndpoints500MsJsonOptionId";
        }

        if (field.isRepeated() && !field.isMapField()) {
            getterName += LIST_SUFFIX;
        }

        return transformKeywords(getterName);
    }

    private String transformKeywords(String getterName) {
        if ("getClass".equals(getterName)) {
            return "getClass_";
        }
        return getterName;
    }

    private POJOPropertyBuilder getPojoPropertyBuilder(PropertyName propertyName) {
        return _property(_properties, propertyName);
    }

    private Descriptors.Descriptor getMessageDescriptor(Class<? extends MessageOrBuilder> messageClass) {
        try {
            return (Descriptors.Descriptor) messageClass.getMethod("getDescriptor").invoke(null);
        } catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
            throw new ProtobufIntrospectionFailedException(e);
        }
    }
}
