#include "yabs_filter_record.h"
#include <yabs/server/libs/filter_record/parse_flags.h>
#include <yabs/server/libs/filter_record/yabs_filter_record.h>
#include <util/generic/strbuf.h>
#include <util/generic/string.h>

static jclass iaeClass;
static jclass eeeClass;

jint JNI_OnLoad(JavaVM *jvm, void *)
{
    JNIEnv *env;
    if (jvm->GetEnv((void**)&env, JNI_VERSION_1_8) != JNI_OK) {
        return -1;
    }

    iaeClass = (jclass)env->NewGlobalRef(env->FindClass("java/lang/IllegalArgumentException"));
    eeeClass = (jclass)env->NewGlobalRef(env->FindClass("java/lang/Error"));

    return JNI_VERSION_1_8;
}

JNIEXPORT jstring JNICALL Java_ru_yandex_crypta_lib_YabsFilterRecord_decode(JNIEnv* env, jclass, jstring raw)
{
    if (!raw) {
        env->ThrowNew(iaeClass, "Can't decode absent string");
        return nullptr;
    }
    auto rawStr = env->GetStringUTFChars(raw, nullptr);
    if (!rawStr) {
        env->ThrowNew(eeeClass, "Internal Error");
        return nullptr;
    }

    TString toSkip = "-";
    TString FilterBuffer = TString(1 << 20, 0);
    TString FilterFlags = TString(GetFlagsSizeInBytes(), 1);

    if (!yabs_filter_record_parse_flags2(const_cast<char*>(toSkip.data()), toSkip.size(), const_cast<char*>(FilterBuffer.data()), FilterBuffer.size(), reinterpret_cast<unsigned char*>(const_cast<char*>(FilterFlags.data())), FilterFlags.size(), false)) {
        env->ThrowNew(eeeClass, "Internal Error");
        return nullptr;
    }

    TStringBuf rawBuf(rawStr);

    yabs_filter_buffer(const_cast<char*>(rawBuf.data()), rawBuf.length(), const_cast<char *>(FilterBuffer.data()), FilterBuffer.size(), reinterpret_cast<unsigned char*>(const_cast<char*>(FilterFlags.data())), FilterFlags.size());

    env->ReleaseStringUTFChars(raw, rawStr);

    return env->NewStringUTF(FilterBuffer.data());
}
