package ru.yandex.crypta.lib.yt;

import java.util.Map;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.crypta.lib.proto.EEnvironment;

public class PathUtils {

    private PathUtils() {

    }

    private final static Map<EEnvironment, String> ENVIRONMENT_TO_PATH = Cf.map(
        EEnvironment.ENV_DEVELOP, "develop",
        EEnvironment.ENV_TESTING, "testing",
        EEnvironment.ENV_PRODUCTION, "production"
    );

    public static String toPath(EEnvironment environment) {
        return ENVIRONMENT_TO_PATH.get(environment);
    }

}
