package ru.yandex.crypta.lib.yt;

import java.util.function.Function;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.tables.YTableEntryTypes;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;
import ru.yandex.yt.ytclient.proxy.YtClient;

public interface YtService {

    Yt getHahn();

    ru.yandex.inside.yt.kosher.async.Yt getHahnAsync();

    YtClient getHahnRpc();

    YtClient getSenecaRpc();

    default <T> ListF<T> readTableJson(YPath path, Function<JsonNode, T> recMapper) {
        return getHahn().tables().read(path, YTableEntryTypes.JACKSON, recs ->
                (ListF<T>) Cf.x(recs).map(recMapper::apply).toList()
        );
    }

    default <T> ListF<T> readTableJsonUtf8(YPath path, Function<JsonNode, T> recMapper) {
        return getHahn().tables().read(path, YTableEntryTypes.JACKSON_UTF8, recs ->
                (ListF<T>) Cf.x(recs).map(recMapper::apply).toList()
        );
    }

    default <T> ListF<T> readTableYson(YPath path, Function<YTreeMapNode, T> recMapper) {
        return getHahn().tables().read(path, YTableEntryTypes.YSON, recs ->
                (ListF<T>) Cf.x(recs).map(recMapper::apply).toList()
        );
    }
}
