#pragma once

#include <crypta/lib/native/features_calculator/features_calculator.h>

#include <ads/bsyeti/libs/profile/profile.h>
#include <yabs/proto/user_profile.pb.h>

#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NCrypta {
    class TCatboostFeaturesCalculator {
    public:
        using TIdToPrefix = THashMap<ui64, TString>;

        TCatboostFeaturesCalculator() = default;

        TCatboostFeaturesCalculator(
            const TFeaturesMapping& featuresMapping,
            const TIdToPrefix& countersToFeatures,
            const TIdToPrefix& keywordsToFeatures
        );

        TVector<float> PrepareFloatFeatures(const yabs::proto::Profile& profile) const;
        TVector<float> PrepareFloatFeatures(const NBSYeti::TProfile& profile) const;

        TString PrepareTextFeatures(const yabs::proto::Profile& profile) const;
        TString PrepareTextFeatures(const NBSYeti::TProfile& profile) const;

        size_t GetNumFloatFeatures() const;

        bool HasAllFeatures(const NBSYeti::TDataFilter& dataFilter) const;

    private:
        TFeaturesCalculator FeaturesCalculator;
        TIdToPrefix CountersToFeatures;
        TIdToPrefix KeywordsToFeatures;
    };
}
