#include "cgiparam.h"

using namespace NCrypta;

TString NCgiParam::GetNonEmptyString(const TCgiParameters& cgi, const TString& field) {
    const auto& value = cgi.Get(field);
    Y_ENSURE(!value.empty(), "Param '" + field + "' is empty");
    return value;
}

template<>
TMaybe<TString> NCgiParam::GetOptional<TString>(const TCgiParameters& cgi, const TString& field) {
    const auto it = cgi.Find(field);

    if (it != cgi.end()) {
        return it->second;
    }

    return Nothing();
}
