#pragma once

#include <library/cpp/cgiparam/cgiparam.h>

#include <util/generic/maybe.h>
#include <util/string/cast.h>

namespace NCrypta::NCgiParam {
    TString GetNonEmptyString(const TCgiParameters& cgi, const TString& field);

    template<typename T>
    TMaybe<T> GetOptional(const TCgiParameters& cgi, const TString& field) {
        const auto& value = GetOptional<TString>(cgi, field);

        if (!value.Defined()) {
            return Nothing();
        }

        T result;
        Y_ENSURE(TryFromString<T>(*value, result), "Param '" + field + "' has invalid type");
        return result;
    }

    template<>
    TMaybe<TString> GetOptional<TString>(const TCgiParameters& cgi, const TString& field);

    template<typename T>
    T Get(const TCgiParameters& cgi, const TString& field) {
        const auto& value = GetOptional<T>(cgi, field);
        Y_ENSURE(value.Defined(), "Param '" + field + "' is not specified");
        return *value;
    }
}
