#pragma once

#include <google/protobuf/descriptor.pb.h>
#include <library/cpp/getoptpb/getoptpb.h>

namespace NCrypta {
    void ParsePbOptions(int argc, const char** argv, google::protobuf::Message& options);
    void ParsePbOptionsExtended(int argc, const char** argv, google::protobuf::Message& options);

    template <typename TOptions>
    TOptions ParsePbOptions(int argc, const char** argv) {
        TOptions options;

        ParsePbOptions(argc, argv, options);

        return options;
    }

    template <typename TOptions>
    TOptions ParsePbOptionsExtended(int argc, const char** argv) {
        TOptions options;

        ParsePbOptionsExtended(argc, argv, options);

        return options;
    }

    TString ParsePbOptionsDynamic(int argc, const char** argv, const TString& serialized_fds, const TString& message_class);
    TString ParsePbOptionsDynamic(int argc, const char** argv, const NProtoBuf::FileDescriptorSet& fds, const TString& message_class);

    bool ProcessCryptaExtensions(NProtoBuf::Message* message);
}
