#include <crypta/lib/native/common/protobuf/node2proto.h>

using namespace NYT;
using namespace ::google::protobuf;


void FillSimpleFields(const TNode& node, Message& proto, const TParseConfig config) {
    auto d = proto.GetDescriptor();
    NYT::TNode nodeWithSimpleFields;
    for (int i = 0, end = d->field_count(); i < end; ++i) {
        const FieldDescriptor* fd = d->field(i);
        const TString columnName = CalcColumnName(*fd, config.UseYtExtention);
        if (node.HasKey(columnName)) {
            if (fd->cpp_type() != FieldDescriptor::CPPTYPE_MESSAGE) {
                nodeWithSimpleFields(columnName, node[columnName]);
            }
        }
    }

    ::YtNodeToProto(nodeWithSimpleFields, proto, config);
}

void FillInnerMessages(const TNode& node, Message& proto, const TParseConfig config) {
    // Yt serialized all inner messages to string

    auto d = proto.GetDescriptor();
    for (int i = 0, end = d->field_count(); i < end; ++i) {
        const NProtoBuf::FieldDescriptor* fd = d->field(i);
        const TString columnName = CalcColumnName(*fd, config.UseYtExtention);
        if (node.HasKey(columnName)) {
            auto& value = node[columnName];
            if (value.GetType() == TNode::Undefined || value.GetType() == TNode::Null) {
                continue;
            }
            if (fd->cpp_type() == FieldDescriptor::CPPTYPE_MESSAGE) {
                auto r = proto.GetReflection();
                bool isParsed = (*r->MutableMessage(&proto, fd)).ParseFromString(node[columnName].AsString());
                Y_ENSURE(isParsed, "could not parse " << proto.GetTypeName());
                continue;
            }
        }
    }
}

void YtNodeFromReaderToProto(const TNode& node, Message& proto, const TParseConfig config) {
    proto.Clear();

    FillSimpleFields(node, proto, config);
    FillInnerMessages(node, proto, config); // for FieldDescriptor::CPPTYPE_MESSAGE fields
}
