#include <google/protobuf/util/message_differencer.h>
#include <crypta/lib/native/common/protobuf/node2proto.h>
#include <crypta/lib/native/common/protobuf/ut/messages.pb.h>
#include <library/cpp/testing/unittest/registar.h>
#include <mapreduce/yt/tests/yt_unittest_lib/yt_unittest_lib.h>
#include <mapreduce/yt/util/temp_table.h>

Y_UNIT_TEST_SUITE(node2proto) {
    TMessage GenerateProto() {
        TMessage proto;
        auto innerMessage = proto.MutableInnerMessage();
        innerMessage->SetUintField(42);
        innerMessage->SetStringField("tratata");
        proto.SetStringField("tratatat");
        proto.SetFloatField(3.14);
        return proto;
    }

    Y_UNIT_TEST(YtNodeFromReaderToProto) {
        NYT::JoblessInitialize();
        auto client = NYT::NTesting::CreateTestClient();

        auto testTable = NYT::TTempTable(client, "TableWithProtoMessages");
        auto path = testTable.Name();

        TMessage proto = GenerateProto();

        auto writer = client->CreateTableWriter<TMessage>(path);
        writer->AddRow(proto);
        writer->Finish();

        auto node = client->CreateTableReader<NYT::TNode>(path)->GetRow();

        TMessage protoFromNode;
        YtNodeFromReaderToProto(node, protoFromNode);

        UNIT_ASSERT(google::protobuf::util::MessageDifferencer::Equals(proto, protoFromNode));
    }
}
