#include "wait_for.h"
#include <library/cpp/threading/future/future.h>
#include <yt/yt/core/concurrency/scheduler.h>

NYT::TErrorOr<void> WaitFor(NThreading::TFuture<void> future) {
    auto promise = NYT::NewPromise<void>();

    future.Subscribe([promise](const NThreading::TFuture<void>& /*result*/) mutable {
        promise.Set();
    });

    return NYT::NConcurrency::WaitFor(promise.ToFuture());
}
