#pragma once

#include <library/cpp/threading/future/future.h>
#include <yt/yt/core/concurrency/scheduler.h>

template<typename T>
NYT::TFuture<T> ToYtFuture(NThreading::TFuture<T> future) {
    auto promise = NYT::NewPromise<T>();

    future.Subscribe([promise](const NThreading::TFuture<T>& result) mutable {
        try {
            promise.Set(result.GetValue());
        } catch (const std::exception& e) {
            promise.Set(NYT::TError(e.what()));
        }
    });

    return promise.ToFuture();
}

template<typename T>
NYT::TErrorOr<T> WaitFor(NThreading::TFuture<T> future) {
    return NYT::NConcurrency::WaitFor(ToYtFuture(future));
}

NYT::TErrorOr<void> WaitFor(NThreading::TFuture<void> future);

template<typename T>
auto WaitFor(NYT::TFuture<T> future) {
    return NYT::NConcurrency::WaitFor(future);
}

template<typename T>
NYT::TErrorOr<void> WaitForAll(const TVector<NThreading::TFuture<T>>& futures) {
    return WaitFor(NThreading::WaitExceptionOrAll(futures));
}

template <class T>
auto WaitForUnique(NYT::TFuture<T> future, NYT::IInvokerPtr invoker = NYT::GetCurrentInvoker())
{
    auto error = NYT::NConcurrency::WaitFor(future.template As<void>(), std::move(invoker));
    // TODO(max42): what about error handling?
    Y_UNUSED(error);
    return future.GetUnique();
}
