#pragma once

#include <crypta/lib/native/crypta_id/crypta_id.h>
#include <util/generic/string.h>

#include <limits>
#include <algorithm>

namespace NCrypta::NCryptaIdGenerator {
    TCryptaId Generate(const TString& type, const TString& value);

    template <typename TContainer, typename TConverter>
    TCryptaId GenerateSingle(const TContainer& container, const TConverter& converter) {
        if (container.empty()) {
            return 0;
        }

        auto lowestCryptaId = std::numeric_limits<TCryptaId>::max();

        for (const auto& item : container) {
            const auto& kvp = converter(item);
            lowestCryptaId = std::min(lowestCryptaId, Generate(kvp.first, kvp.second));
        }

        return lowestCryptaId;
    }
}
