#pragma once

#include "record.h"

#include <util/datetime/base.h>

namespace NCrypta {
    class IDatabase {
    public:
        using TRequestId = size_t;

        virtual TRequestId Get(const TString& key, const TDuration& ttl = TDuration()) = 0;
        virtual TRequestId Store(const TRecord& record, const TDuration& ttl = TDuration()) = 0;
        virtual TRequestId Remove(const TString& key, ui64 cas = TRecord::NO_CAS) = 0;

        virtual ~IDatabase() = default;
    };

    using IDatabasePtr = TAtomicSharedPtr<IDatabase>;
}
