import six

from crypta.lib.native.database.record cimport TRecord as TRecordImpl
from util.generic.string cimport TString

cdef class TRecord:
    @staticmethod
    def Create(key, value):
        self = TRecord()
        self._cpp_impl.Key = six.ensure_binary(key)
        self._cpp_impl.Value = six.ensure_binary(value)
        return self

    @property
    def Key(self):
        return six.ensure_str(self._cpp_impl.Key)

    @property
    def Value(self):
        return six.ensure_binary(self._cpp_impl.Value)

    def __repr__(self):
        return "TRecord('{}', '{}')".format(self.Key, self.Value)
    
    def __eq__(self, TRecord other):
        return self._cpp_impl == other._cpp_impl

    def __ne__(self, TRecord other):
        return self._cpp_impl != other._cpp_impl
