#pragma once

#include "database.h"

namespace NCrypta {
    class IReplyHandler {
    public:
        using TGetHandler = std::function<void(IDatabase::TRequestId requestId, TMaybe<TRecord>&& record)>;
        using TStoreHandler = std::function<void(IDatabase::TRequestId requestId, TString&& key)>;
        using TRemoveHandler = std::function<void(IDatabase::TRequestId requestId, TString&& key)>;
        using TErrorHandler = std::function<void(IDatabase::TRequestId requestId, TString&& key, TString&& error)>;

        virtual bool TryProcessReply() = 0;

        virtual void SetGetHandler(const TGetHandler& handler) = 0;
        virtual void SetStoreHandler(const TStoreHandler& handler) = 0;
        virtual void SetRemoveHandler(const TRemoveHandler& handler) = 0;
        virtual void SetErrorHandler(const TErrorHandler& handler) = 0;

        virtual ~IReplyHandler() = default;
    };

    using IReplyHandlerPtr = TAtomicSharedPtr<IReplyHandler>;
}
